// Example navigation function
function navigateToPage(pageUrl) {
    // Use AJAX to fetch the new page content
    $.ajax({
        url: pageUrl,
        type: 'GET',
        dataType: 'html',
        success: function(data) {
            // Update the main content area with the new page content
            $('#main-content').html(data);

            // Optionally, update the browser URL using pushState
            history.pushState(null, null, pageUrl);
        },
        error: function(xhr, status, error) {
            console.error('Error loading page:', status, error);
        }
    });
}

// Example usage:
$(document).ready(function() {
    // Handle clicks on links with class 'nav-link'
    $('.nav-link').click(function(e) {
        e.preventDefault(); // Prevent the default link behavior

        var pageUrl = $(this).attr('href'); // Get the URL of the clicked link
        navigateToPage(pageUrl); // Call the navigation function
    });
});
