<?php
include "header.php";
include "sidebar.php";

// Check if form is submitted to activate/deactivate comment status
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['comment_id']) && isset($_POST['status'])) {
    // Include your database connection file
    include 'db_connection.php';

    // Retrieve comment ID and status from the form submission
    $comment_id = $_POST['comment_id'];
    $status = $_POST['status'];

    // Update the status of the comment in the database
    $sql = "UPDATE comments SET status = ? WHERE id = ?";
    $stmt = mysqli_prepare($con, $sql);
    mysqli_stmt_bind_param($stmt, "ii", $status, $comment_id);
    mysqli_stmt_execute($stmt);

    // Check if comment status is updated successfully
    if (mysqli_stmt_affected_rows($stmt) > 0) {
        echo "Comment status updated successfully.";
    } else {
        echo "Error updating comment status: " . mysqli_error($con);
    }

    // Close statement and database connection
    mysqli_stmt_close($stmt);
    mysqli_close($con);
}

?>

<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0">Comment Management</h4>
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">All</a></li>
                                <li class="breadcrumb-item active">Comment Management</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            <!-- end page title -->

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">List Of Comment</h5>
                            <div class="hstack gap-2 justify-content-end">
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="example" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
                                <thead>
                                    <tr>
                                        <th data-ordering="false">Blog</th>
                                        <th data-ordering="false">Name</th>
                                        <th data-ordering="false">Comment</th>
                                        <th data-ordering="false">Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php
                                    $q = "SELECT c.id, c.postId, c.name, c.comment, c.status, p.port_title FROM comments c INNER JOIN portfolio p ON c.postId = p.id ORDER BY c.id DESC";
                                    $r123 = mysqli_query($con, $q);

                                    while ($ro = mysqli_fetch_array($r123)) {
                                        $id = $ro['id'];
                                        $postId = $ro['postId'];
                                        $name = $ro['name'];
                                        $comment = $ro['comment'];
                                        $status = ($ro['status'] == 0) ? 'Not Active' : 'Active';
                                        $port_title = $ro['port_title'];

                                        echo "<tr>
                                            <td>$port_title</td>
                                            <td>$name</td>
                                            <td>$comment</td>
                                            <td>$status</td>
                                            <td>
                                                <div class='dropdown d-inline-block'>
                                                    <button class='btn btn-soft-secondary btn-sm dropdown' type='button' data-bs-toggle='dropdown' aria-expanded='false'>
                                                        <i class='ri-more-fill align-middle'></i>
                                                    </button>
                                                    <ul class='dropdown-menu dropdown-menu-end'>
                                                        <li><a href='deletecomment.php?id=$id' class='dropdown-item remove-item-btn'><i class='ri-delete-bin-fill align-bottom me-2 text-muted'></i> Delete</a></li>
                                                        <li><a href='javascript:void(0);' class='dropdown-item' onclick='updateStatus($id, $status);'><i class='ri-checkbox-circle-fill align-bottom me-2 text-muted'></i> Toggle Status</a></li>
                                                    </ul>
                                                </div>
                                            </td>
                                        </tr>";
                                    }
                                    ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div><!-- end row -->

        </div>
        <!-- container-fluid -->
    </div>
    <!-- End Page-content -->

    <?php include "footer.php"; ?>
</div>

<script>
    // Function to update comment status
    function updateStatus(commentId, currentStatus) {
    var newStatus = (currentStatus == 0) ? 1 : 0; // Toggle status
    $.post("editstatus.php", {
        comment_id: commentId,
        status: newStatus
    }).done(function(response) {
        // Refresh the page or update UI as needed
        console.log(response);
        location.reload(); // Refresh the page after status update
    });
}
</script>

