<?php
include_once("../z_db.php");

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = mysqli_real_escape_string($con, $_POST['username']);
    $keyword = mysqli_real_escape_string($con, $_POST['keyword']);
    $new_password = mysqli_real_escape_string($con, $_POST['new_password']);
    $confirm_password = mysqli_real_escape_string($con, $_POST['confirm_password']);
    
    // Check if passwords match
    if ($new_password != $confirm_password) {
        $errormsg = "<div class='alert alert-danger alert-dismissible alert-outline fade show'>
            Passwords do not match.
            <button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button>
        </div>";
    } else {
        // Check if username and keyword match
        $query = "SELECT id FROM admin WHERE username = ? AND keyword = ?";
        if ($stmt = mysqli_prepare($con, $query)) {
            mysqli_stmt_bind_param($stmt, "ss", $username, $keyword);
            mysqli_stmt_execute($stmt);
            mysqli_stmt_store_result($stmt);

            if (mysqli_stmt_num_rows($stmt) == 1) {
                // Update password
                $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
                $updateQuery = "UPDATE admin SET password = ? WHERE username = ? AND keyword = ?";
                if ($updateStmt = mysqli_prepare($con, $updateQuery)) {
                    mysqli_stmt_bind_param($updateStmt, "sss", $hashed_password, $username, $keyword);
                    mysqli_stmt_execute($updateStmt);
                    $errormsg = "<div class='alert alert-success alert-dismissible alert-outline fade show'>
                        Password updated successfully.
                        <button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button>
                    </div>";
                } else {
                    $errormsg = "<div class='alert alert-danger alert-dismissible alert-outline fade show'>
                        Error updating password.
                        <button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button>
                    </div>";
                }
            } else {
                $errormsg = "<div class='alert alert-danger alert-dismissible alert-outline fade show'>
                    Username and keyword do not match.
                    <button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button>
                </div>";
            }
            mysqli_stmt_close($stmt);
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>EKV Sign In Dashboard</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/png" href="images/icons/favicon.ico"/>
    <link rel="stylesheet" type="text/css" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="fonts/font-awesome-4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" type="text/css" href="fonts/iconic/css/material-design-iconic-font.min.css">
    <link rel="stylesheet" type="text/css" href="vendor/animate/animate.css">
    <link rel="stylesheet" type="text/css" href="vendor/css-hamburgers/hamburgers.min.css">
    <link rel="stylesheet" type="text/css" href="vendor/animsition/css/animsition.min.css">
    <link rel="stylesheet" type="text/css" href="vendor/select2/select2.min.css">
    <link rel="stylesheet" type="text/css" href="vendor/daterangepicker/daterangepicker.css">
    <link rel="stylesheet" type="text/css" href="css/util.css">
    <link rel="stylesheet" type="text/css" href="css/main.css">
</head>
<body>
    <div class="limiter">
        <div class="container-login100" style="background-image: url('images/bg-01.jpg');">
            <div class="wrap-login100">
                <?php if (isset($errormsg)) { echo $errormsg; } ?>
                <form class="login100-form validate-form" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"], ENT_QUOTES, "utf-8"); ?>" method="post">
                    <span class="login100-form-logo">
                        <?php
                        $rr = mysqli_query($con, "SELECT ufile FROM logo");
                        $r = mysqli_fetch_row($rr);
                        $ufile = $r[0];
                        ?>
                        <a href="#" class="d-block">
                            <img src="uploads/logo/<?php echo $ufile; ?>" alt="" height="60">
                        </a>
                    </span>
                    <span class="login100-form-title p-b-34 p-t-27">
                        Forgot Password
                    </span>
                    <div class="wrap-input100 validate-input" data-validate="Enter username">
                        <input class="input100" type="text" id="username" name="username" placeholder="Username" required>
                        <span class="focus-input100" data-placeholder="&#xf207;"></span>
                    </div>
                    <div class="wrap-input100 validate-input" data-validate="Enter keyword">
                        <input class="input100" type="text" id="keyword" name="keyword" placeholder="Keyword" required>
                        <span class="focus-input100" data-placeholder="&#xf14b;"></span>
                    </div>
                    <div class="wrap-input100 validate-input" data-validate="Enter new password">
                        <input class="input100" type="password" name="new_password" id="newPassword" placeholder="New Password" required>
                        <span class="focus-input100" data-placeholder="&#xf191;"></span>
                    </div>
                    <div class="wrap-input100 validate-input" data-validate="Re-enter new password">
                        <input class="input100" type="password" name="confirm_password" id="confirmPassword" placeholder="Re-enter New Password" required>
                        <span class="focus-input100" data-placeholder="&#xf191;"></span>
                    </div>
                    <div class="container-login100-form-btn">
                        <button class="login100-form-btn" type="submit">Reset Password</button>
                    </div>
                    <div class="text-center p-t-90">
                        <a class="txt1" href="index.php">Back to login</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div id="dropDownSelect1"></div>
    <script src="vendor/jquery/jquery-3.2.1.min.js"></script>
    <script src="vendor/animsition/js/animsition.min.js"></script>
    <script src="vendor/bootstrap/js/popper.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.min.js"></script>
    <script src="vendor/select2/select2.min.js"></script>
    <script src="vendor/daterangepicker/moment.min.js"></script>
    <script src="vendor/daterangepicker/daterangepicker.js"></script>
    <script src="vendor/countdowntime/countdowntime.js"></script>
    <script src="js/main.js"></script>
</body>
</html>
