<?php
// Include your database connection file
include 'z_db.php';

// Check if comment_id and status are set
if (isset($_POST['comment_id']) && isset($_POST['status'])) {
    // Retrieve comment ID and status from the AJAX request
    $comment_id = $_POST['comment_id'];
    $status = $_POST['status'];

    // Update the status of the comment in the database
    $sql = "UPDATE comments SET status = ? WHERE id = ?";
    $stmt = mysqli_prepare($con, $sql);
    mysqli_stmt_bind_param($stmt, "ii", $status, $comment_id);
    mysqli_stmt_execute($stmt);

    // Check if comment status is updated successfully
    if (mysqli_stmt_affected_rows($stmt) > 0) {
        echo "Comment status updated successfully.";
    } else {
        echo "Error updating comment status: " . mysqli_error($con);
    }

    // Close statement and database connection
    mysqli_stmt_close($stmt);
    mysqli_close($con);
} else {
    echo "Invalid request."; // Handle invalid request
}
?>
