<?php
include "header.php";
include "sidebar.php";

// Fetch admin's password
$query = "SELECT password FROM admin WHERE username = 'admin'";
$result = mysqli_query($con, $query);
$row = mysqli_fetch_assoc($result);

$status = "OK"; // Initial status
$msg = "";

// Check if form is submitted
if (isset($_POST['save'])) {
    // Get form data
    $currentPassword = mysqli_real_escape_string($con, $_POST['current_password']);
    $newPassword = mysqli_real_escape_string($con, $_POST['new_password']);
    $confirmPassword = mysqli_real_escape_string($con, $_POST['confirm_password']);

    // Verify current password
    if (password_verify($currentPassword, $row['password'])) {
        // Validate new password
        if (strlen($newPassword) < 8) {
            $msg .= "New password must be at least 8 characters long.<br>";
            $status = "NOTOK";
        } elseif ($newPassword != $confirmPassword) {
            $msg .= "New password and confirm password do not match.<br>";
            $status = "NOTOK";
        }

        if ($status == "OK") {
            // Hash the new password
            $hashedPassword = password_hash($newPassword, PASSWORD_DEFAULT);

            // Update the password in the database
            $updateQuery = "UPDATE admin SET password='$hashedPassword' WHERE username = 'admin'";
            $updateResult = mysqli_query($con, $updateQuery);

            if ($updateResult) {
                $errormsg = "<div class='alert alert-success alert-dismissible alert-outline fade show'>Password updated successfully.<button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button></div>";
            } else {
                $errormsg = "<div class='alert alert-danger alert-dismissible alert-outline fade show'>Error updating password.<button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button></div>";
            }
        }
    } else {
        $errormsg = "<div class='alert alert-danger alert-dismissible alert-outline fade show'>Incorrect current password.<button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button></div>";
    }
}
?>

<!-- Change Password Form -->
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0">Change Password</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Profile</a></li>
                                <li class="breadcrumb-item active">Change Password</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->
            <br><br>
            <div class="row">
                <div class="col-xxl-9">
                    <div class="card mt-xxl-n5">
                        <div class="card-header">
                            <ul class="nav nav-tabs-custom rounded card-header-tabs border-bottom-0" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active" data-bs-toggle="tab" href="#changePassword" role="tab"
                                        aria-selected="false">
                                        <i class="fas fa-key"></i> Change Password
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <div class="card-body p-4">
                            <?php
                            if ($_SERVER['REQUEST_METHOD'] == 'POST') {
                                echo $errormsg;
                            }
                            ?>
                            <form action="" method="post">
                                <div class="mb-3">
                                    <label for="currentPassword" class="form-label">Current Password</label>
                                    <input type="password" class="form-control" name="current_password" id="currentPassword" placeholder="Enter current password" required>
                                </div>
                                <div class="mb-3">
                                    <label for="newPassword" class="form-label">New Password</label>
                                    <input type="password" class="form-control" name="new_password" id="newPassword" placeholder="Enter new password" required>
                                </div>
                                <div class="mb-3">
                                    <label for="confirmPassword" class="form-label">Confirm Password</label>
                                    <input type="password" class="form-control" name="confirm_password" id="confirmPassword" placeholder="Confirm new password" required>
                                </div>
                                <button type="submit" name="save" class="btn btn-primary">Change Password</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- container-fluid -->

<?php include "footer.php"; ?>
